/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.conic;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedShape2DException;
import math.geom2d.Vector2D;
import math.geom2d.conic.Conic2D;
import math.geom2d.conic.Conic2DUtils;
import math.geom2d.conic.HyperbolaBranch2D;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hyperbola2D
extends ContourArray2D<HyperbolaBranch2D>
implements Conic2D,
Cloneable {
    protected double xc = 0.0;
    protected double yc = 0.0;
    protected double a = 1.0;
    protected double b = 1.0;
    protected double theta = 0.0;
    protected boolean direct = true;
    protected HyperbolaBranch2D branch1 = null;
    protected HyperbolaBranch2D branch2 = null;

    public static Hyperbola2D create(Point2D center, double a, double b, double theta) {
        return new Hyperbola2D(center.getX(), center.getY(), a, b, theta, true);
    }

    public static Hyperbola2D create(Point2D center, double a, double b, double theta, boolean d) {
        return new Hyperbola2D(center.getX(), center.getY(), a, b, theta, d);
    }

    public static Hyperbola2D reduceCentered(double[] coefs) {
        double r2;
        double r1;
        double theta;
        double A = coefs[0];
        double B = coefs[1];
        double C = coefs[2];
        if (Math.abs(A - C) < 1.0E-12) {
            theta = 0.7853981633974483;
        } else {
            theta = Math.atan2(B, A - C) / 2.0;
            if (B < 0.0) {
                theta -= Math.PI;
            }
            theta = Angle2D.formatAngle(theta);
        }
        double[] coefs2 = Conic2DUtils.transformCentered(coefs, AffineTransform2D.createRotation(-theta));
        double f = 1.0;
        if (coefs2.length > 5) {
            f = Math.abs(coefs[5]);
        }
        assert (Math.abs(coefs2[1] / f) < 1.0E-12) : "Second conic coefficient should be zero";
        assert (coefs2[0] * coefs2[2] < 0.0) : "Transformed conic is not an Hyperbola";
        if (coefs2[0] > 0.0) {
            r1 = Math.sqrt(f / coefs2[0]);
            r2 = Math.sqrt(-f / coefs2[2]);
        } else {
            r1 = Math.sqrt(f / coefs2[2]);
            r2 = Math.sqrt(-f / coefs2[0]);
            theta = Angle2D.formatAngle(theta + 1.5707963267948966);
            theta = Math.min(theta, Angle2D.formatAngle(theta + Math.PI));
        }
        return new Hyperbola2D(0.0, 0.0, r1, r2, theta, true);
    }

    public static Hyperbola2D transformCentered(Hyperbola2D hyper, AffineTransform2D trans) {
        double a = hyper.a;
        double b = hyper.b;
        double theta = hyper.theta;
        double aSq = a * a;
        double bSq = b * b;
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        double cotSq = cot * cot;
        double sitSq = sit * sit;
        double A = cotSq / aSq - sitSq / bSq;
        double B = 2.0 * cot * sit * (1.0 / aSq + 1.0 / bSq);
        double C = sitSq / aSq - cotSq / bSq;
        double[] coefs = new double[]{A, B, C};
        double[] coefs2 = Conic2DUtils.transformCentered(coefs, trans);
        return Hyperbola2D.reduceCentered(coefs2);
    }

    public Hyperbola2D() {
        this(0.0, 0.0, 1.0, 1.0, 0.0, true);
    }

    public Hyperbola2D(Point2D center, double a, double b, double theta) {
        this(center.getX(), center.getY(), a, b, theta, true);
    }

    public Hyperbola2D(Point2D center, double a, double b, double theta, boolean d) {
        this(center.getX(), center.getY(), a, b, theta, d);
    }

    public Hyperbola2D(double xc, double yc, double a, double b, double theta) {
        this(xc, yc, a, b, theta, true);
    }

    public Hyperbola2D(double xc, double yc, double a, double b, double theta, boolean d) {
        this.xc = xc;
        this.yc = yc;
        this.a = a;
        this.b = b;
        this.theta = theta;
        this.direct = d;
        this.branch1 = new HyperbolaBranch2D(this, false);
        this.branch2 = new HyperbolaBranch2D(this, true);
        this.addCurve(this.branch1);
        this.addCurve(this.branch2);
    }

    public Point2D toGlobal(Point2D point) {
        point = point.transform(AffineTransform2D.createScaling(this.a, this.b));
        point = point.transform(AffineTransform2D.createRotation(this.theta));
        point = point.transform(AffineTransform2D.createTranslation(this.xc, this.yc));
        return point;
    }

    public Point2D toLocal(Point2D point) {
        point = point.transform(AffineTransform2D.createTranslation(-this.xc, -this.yc));
        point = point.transform(AffineTransform2D.createRotation(-this.theta));
        point = point.transform(AffineTransform2D.createScaling(1.0 / this.a, 1.0 / this.b));
        return point;
    }

    private LinearShape2D formatLine(LinearShape2D line) {
        line = line.transform(AffineTransform2D.createTranslation(-this.xc, -this.yc));
        line = line.transform(AffineTransform2D.createRotation(-this.theta));
        line = line.transform(AffineTransform2D.createScaling(1.0 / this.a, 1.0 / this.b));
        return line;
    }

    public Point2D getCenter() {
        return new Point2D(this.xc, this.yc);
    }

    public double getAngle() {
        return this.theta;
    }

    public double getLength1() {
        return this.a;
    }

    public double getLength2() {
        return this.b;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public Vector2D getVector1() {
        return new Vector2D(Math.cos(this.theta), Math.sin(this.theta));
    }

    public Vector2D getVector2() {
        return new Vector2D(-Math.sin(this.theta), Math.cos(this.theta));
    }

    public Point2D getFocus1() {
        double c = Math.hypot(this.a, this.b);
        return new Point2D(this.xc + c * Math.cos(this.theta), this.yc + c * Math.sin(this.theta));
    }

    public Point2D getFocus2() {
        double c = Math.hypot(this.a, this.b);
        return new Point2D(this.xc - c * Math.cos(this.theta), this.yc - c * Math.sin(this.theta));
    }

    public HyperbolaBranch2D getPositiveBranch() {
        return this.branch2;
    }

    public HyperbolaBranch2D getNegativeBranch() {
        return this.branch1;
    }

    public Collection<HyperbolaBranch2D> getBranches() {
        ArrayList<HyperbolaBranch2D> array = new ArrayList<HyperbolaBranch2D>(2);
        array.add(this.branch1);
        array.add(this.branch2);
        return array;
    }

    public Collection<StraightLine2D> getAsymptotes() {
        Vector2D v1 = new Vector2D(this.a, this.b);
        Vector2D v2 = new Vector2D(this.a, -this.b);
        AffineTransform2D rot = AffineTransform2D.createRotation(this.theta);
        v1 = v1.transform(rot);
        v2 = v2.transform(rot);
        ArrayList<StraightLine2D> array = new ArrayList<StraightLine2D>(2);
        Point2D center = this.getCenter();
        array.add(new StraightLine2D(center, v1));
        array.add(new StraightLine2D(center, v2));
        return array;
    }

    @Override
    public double[] getConicCoefficients() {
        double aSq = this.a * this.a;
        double bSq = this.b * this.b;
        double aSqInv = 1.0 / aSq;
        double bSqInv = 1.0 / bSq;
        double sint = Math.sin(this.theta);
        double cost = Math.cos(this.theta);
        double sin2t = 2.0 * sint * cost;
        double sintSq = sint * sint;
        double costSq = cost * cost;
        double xcSq = this.xc * this.xc;
        double ycSq = this.yc * this.yc;
        double a = costSq / aSq - sintSq / bSq;
        double b = (bSq + aSq) * sin2t / (aSq * bSq);
        double c = sintSq / aSq - costSq / bSq;
        double d = -this.yc * b - 2.0 * this.xc * a;
        double e = -this.xc * b - 2.0 * this.yc * c;
        double f = -1.0 + (xcSq + ycSq) * (aSqInv - bSqInv) / 2.0 + (costSq - sintSq) * (xcSq - ycSq) * (aSqInv + bSqInv) / 2.0 + this.xc * this.yc * (aSqInv + bSqInv) * sin2t;
        return new double[]{a, b, c, d, e, f};
    }

    @Override
    public Conic2D.Type getConicType() {
        return Conic2D.Type.HYPERBOLA;
    }

    @Override
    public double getEccentricity() {
        return Math.hypot(1.0, this.b * this.b / this.a / this.a);
    }

    @Override
    public Hyperbola2D getReverseCurve() {
        return new Hyperbola2D(this.xc, this.yc, this.a, this.b, this.theta, !this.direct);
    }

    @Override
    public Collection<Point2D> getIntersections(LinearShape2D line) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        LinearShape2D line2 = this.formatLine(line);
        Point2D origin = line2.getOrigin();
        double dx = line2.getVector().getX();
        double dy = line2.getVector().getY();
        if (Math.abs(dx) > Math.abs(dy)) {
            double pos2;
            double pos1;
            double c;
            double a;
            double k = dy / dx;
            double yi = origin.getY() - k * origin.getX();
            double b = -2.0 * k * yi;
            double delta = b * b - 4.0 * (a = 1.0 - k * k) * (c = -yi * yi - 1.0);
            if (delta <= 0.0) {
                System.out.println("Intersection with horizontal line should alays give positive delta");
                return points;
            }
            double x1 = (-b - Math.sqrt(delta)) / (2.0 * a);
            double x2 = (-b + Math.sqrt(delta)) / (2.0 * a);
            StraightLine2D support = line2.getSupportingLine();
            if (line2.contains(support.getPoint(pos1 = support.project(new Point2D(x1, k * x1 + yi))))) {
                points.add(line.getPoint(pos1));
            }
            if (line2.contains(support.getPoint(pos2 = support.project(new Point2D(x2, k * x2 + yi))))) {
                points.add(line.getPoint(pos2));
            }
        } else {
            double pos2;
            double pos1;
            double c;
            double a;
            double k = dx / dy;
            double xi = origin.getX() - k * origin.getY();
            double b = 2.0 * k * xi;
            double delta = b * b - 4.0 * (a = k * k - 1.0) * (c = xi * xi - 1.0);
            if (delta <= 0.0) {
                return points;
            }
            double y1 = (-b - Math.sqrt(delta)) / (2.0 * a);
            double y2 = (-b + Math.sqrt(delta)) / (2.0 * a);
            StraightLine2D support = line2.getSupportingLine();
            if (line2.contains(support.getPoint(pos1 = support.project(new Point2D(k * y1 + xi, y1))))) {
                points.add(line.getPoint(pos1));
            }
            if (line2.contains(support.getPoint(pos2 = support.project(new Point2D(k * y2 + xi, y2))))) {
                points.add(line.getPoint(pos2));
            }
        }
        return points;
    }

    @Override
    public boolean contains(Point2D point) {
        return this.contains(point.getX(), point.getY());
    }

    @Override
    public boolean contains(double x, double y) {
        double yb;
        Point2D point = this.toLocal(new Point2D(x, y));
        double xa = point.getX() / this.a;
        double res = xa * xa - (yb = point.getY() / this.b) * yb - 1.0;
        return Math.abs(res) < 1.0E-6;
    }

    @Override
    public Hyperbola2D transform(AffineTransform2D trans) {
        Hyperbola2D result = Hyperbola2D.transformCentered(this, trans);
        Point2D center = this.getCenter().transform(trans);
        result.xc = center.getX();
        result.yc = center.getY();
        result.direct = this.direct ^ !trans.isDirect();
        return result;
    }

    @Override
    public void draw(Graphics2D g) {
        throw new UnboundedShape2DException(this);
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Hyperbola2D)) {
            return false;
        }
        Hyperbola2D that = (Hyperbola2D)obj;
        if (Math.abs(that.xc - this.xc) > eps) {
            return false;
        }
        if (Math.abs(that.yc - this.yc) > eps) {
            return false;
        }
        if (Math.abs(that.a - this.a) > eps) {
            return false;
        }
        if (Math.abs(that.b - this.b) > eps) {
            return false;
        }
        if (Math.abs(that.theta - this.theta) > eps) {
            return false;
        }
        return this.direct == that.direct;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Hyperbola2D)) {
            return false;
        }
        Hyperbola2D that = (Hyperbola2D)obj;
        double eps = 1.0E-6;
        if (Math.abs(that.xc - this.xc) > eps) {
            return false;
        }
        if (Math.abs(that.yc - this.yc) > eps) {
            return false;
        }
        if (Math.abs(that.a - this.a) > eps) {
            return false;
        }
        if (Math.abs(that.b - this.b) > eps) {
            return false;
        }
        if (Math.abs(that.theta - this.theta) > eps) {
            return false;
        }
        return this.direct == that.direct;
    }

    @Override
    public Hyperbola2D clone() {
        return new Hyperbola2D(this.xc, this.yc, this.a, this.b, this.theta, this.direct);
    }
}

